const chromeLauncher = require("chrome-launcher");
const chromeRemoteInterface = require('chrome-remote-interface');

const fs = require('fs');
const { spawn } = require("child_process");

const ffmpeg = require('fluent-ffmpeg');
const ffmpegPath = require("ffmpeg-binaries");

const stream = require('stream');

/*
function delay(t, v) {
   return new Promise(function(resolve) { 
       setTimeout(resolve.bind(null, v), t)
   });
}
*/

const framerate = 30;
const dimensions = {
	width: 1920, 
	height: 1080
};
const nbFrameCpture = 500;

var frames = [];

//Launch Chrome
(async function() {

	async function launchChrome(headless=true) {
    	return await chromeLauncher.launch({
    		 port: 9222,
      		chromeFlags: [
        		`--window-size=${dimensions.width},${dimensions.height}`,
				"disable-gpu",
				headless ? "--headless" : ""
      		]
    	});
  	}

	async function loadPage(page, url)
	{
		await page.navigate({url: url});
	}

	function startCapturingFrames(page)
	{
		return page.startScreencast({
			format: "jpeg",
			quality: 100,
			//everyNthFrame: 1		
		});
	}

	function stopCapturingFrames(page)
	{
		page.stopScreencast();
	}

	async function stopChrome(chrome)
	{
		await chrome.kill();
	}

	console.log("[DEBUG] info: ", "Start.");	
	/*
	var childProcess = spawn('bin/ffmpeg.exe', ['-y', '-f', 'image2pipe',
	    '-s', `${dimensions.width}x${dimensions.height}`,
	    '-framerate', framerate,
	    '-pix_fmt', 'yuv420p',
	    '-i', '-',
	    '-vcodec', 'mpeg4',
	    '-shortest',
	    outputFilename
	]);
		

	childProcess.stdout.on('data', data => console.log(data.toString()));
	childProcess.stderr.on('data', data => console.log(data.toString()));
	childProcess.on('close', code => {
	    console.log(`done! (${code})`);
	    resolve();
	});


	var imagesStream = new stream.PassThrough();
	imagesStream.pipe(childProcess.stdin);
	*/

	const chrome = await launchChrome();
	console.log("[DEBUG] info: ", "Chrome launched on port ", chrome.port);

	const client = await chromeRemoteInterface({port: chrome.port});
	console.log("[DEBUG] info: ", "Chrome remote interface on port ", client.port);

    const {Network, Page} = client;

    Network.requestWillBeSent((params) => {
        console.log(params.request.url);
    });
    await Network.enable();
    await Page.enable();

    await Page.navigate({url: 'https://tv.citia.org/#/player/festival/none/horizontal/2018-06-11_09:00:00/2018-06-11_18:00:00'});
	console.log("[DEBUG] info: ", "Launching page.");

    await Page.loadEventFired();
	console.log("[DEBUG] info: ", "Page loaded.");

	Page.startScreencast({
		format: "jpeg",
		quality: 100,
		everyNthFrame: 1		
	});

	let counter = 0;
    while(counter <= nbFrameCpture){
		console.log("[DEBUG] info: ", "Start capturing screen frame ", counter);    	
	    const {data, metadata, sessionId} = await Page.screencastFrame();

		//frames.push(Buffer.from(data));	
	    
	    const filename = "./citia/image-" + ("000000" + counter).slice(-6) + ".jpg";

	    await fs.writeFile(filename, data, { encoding: 'base64' }, (error) => {
      		console.log('Page.screencastFrame writeFile:', filename, error)
    	});
    	

	    await Page.screencastFrameAck({sessionId: sessionId});
  		counter += 1;
    }

    stopCapturingFrames(Page);
    stopChrome(chrome);	

    
	console.log("[DEBUG] info: ", "End.");
	process.exit(0);
})();
